unit uWinForm;
//------------------------------------------------------------------------------
//  Last updated:   11/06/03
//  Author:         Dennis Passmore
//  Company:        Ultimate Software, Inc.
//  Contact info:   dennis_passmore@ultimatesoftware.com
//
//  Compatibility:  Delphi for .NET HTTP service demo
//
//  Description:    TNTKeyService class implements base .NET service class.
//                  TLockserver class implements base ILockserver which is
//                  exported via .NET Remoting
//
//------------------------------------------------------------------------------
interface

uses
  System.IO,
  System.Drawing,
  System.Collections,
  System.ComponentModel,
  System.Windows.Forms,
  System.Runtime.Remoting,
  Borland.VCL.Sysutils, uRNGintf;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    btnLockItem: System.Windows.Forms.Button;
    tbxLockContext: System.Windows.Forms.TextBox;
    lbxResults: System.Windows.Forms.ListBox;
    btnIsLocked: System.Windows.Forms.Button;
    btnUnLock: System.Windows.Forms.Button;
    lblLockContext: System.Windows.Forms.Label;
    tbxLockKey: System.Windows.Forms.TextBox;
    lblLockKey: System.Windows.Forms.Label;
    lblResults: System.Windows.Forms.Label;
    tbxLockServer: System.Windows.Forms.TextBox;
    lblLockServer: System.Windows.Forms.Label;
    tbxPort: System.Windows.Forms.TextBox;
    lblPort: System.Windows.Forms.Label;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure LockItem_Click(sender: System.Object; e: System.EventArgs);
    procedure IsLocked_Click(sender: System.Object; e: System.EventArgs);
    procedure UnLock_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  protected
    function GetobjectRef: ILockserver;
    procedure DisplayResults(const fMsg: string);
  public
    constructor Create;
  end;

implementation

uses
  System.Globalization;

const
  TF: array[boolean] of string = ('False','True');

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.btnLockItem := System.Windows.Forms.Button.Create;
  Self.tbxLockContext := System.Windows.Forms.TextBox.Create;
  Self.lbxResults := System.Windows.Forms.ListBox.Create;
  Self.btnIsLocked := System.Windows.Forms.Button.Create;
  Self.btnUnLock := System.Windows.Forms.Button.Create;
  Self.lblLockContext := System.Windows.Forms.Label.Create;
  Self.tbxLockKey := System.Windows.Forms.TextBox.Create;
  Self.lblLockKey := System.Windows.Forms.Label.Create;
  Self.lblResults := System.Windows.Forms.Label.Create;
  Self.tbxLockServer := System.Windows.Forms.TextBox.Create;
  Self.lblLockServer := System.Windows.Forms.Label.Create;
  Self.tbxPort := System.Windows.Forms.TextBox.Create;
  Self.lblPort := System.Windows.Forms.Label.Create;
  Self.SuspendLayout;
  // 
  // btnLockItem
  // 
  Self.btnLockItem.Location := System.Drawing.Point.Create(24, 139);
  Self.btnLockItem.Name := 'btnLockItem';
  Self.btnLockItem.Size := System.Drawing.Size.Create(64, 23);
  Self.btnLockItem.TabIndex := 0;
  Self.btnLockItem.Text := 'LockItem';
  Include(Self.btnLockItem.Click, Self.LockItem_Click);
  // 
  // tbxLockContext
  // 
  Self.tbxLockContext.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
      or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.tbxLockContext.Location := System.Drawing.Point.Create(16, 64);
  Self.tbxLockContext.Name := 'tbxLockContext';
  Self.tbxLockContext.Size := System.Drawing.Size.Create(264, 20);
  Self.tbxLockContext.TabIndex := 1;
  Self.tbxLockContext.Text := 'NamedLockContext';
  // 
  // lbxResults
  // 
  Self.lbxResults.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
      or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
      or System.Windows.Forms.AnchorStyles.Right)));
  Self.lbxResults.Location := System.Drawing.Point.Create(16, 184);
  Self.lbxResults.Name := 'lbxResults';
  Self.lbxResults.Size := System.Drawing.Size.Create(264, 43);
  Self.lbxResults.TabIndex := 2;
  // 
  // btnIsLocked
  // 
  Self.btnIsLocked.Location := System.Drawing.Point.Create(117, 139);
  Self.btnIsLocked.Name := 'btnIsLocked';
  Self.btnIsLocked.Size := System.Drawing.Size.Create(64, 23);
  Self.btnIsLocked.TabIndex := 3;
  Self.btnIsLocked.Text := 'Is-Locked';
  Include(Self.btnIsLocked.Click, Self.IsLocked_Click);
  // 
  // btnUnLock
  // 
  Self.btnUnLock.Location := System.Drawing.Point.Create(208, 139);
  Self.btnUnLock.Name := 'btnUnLock';
  Self.btnUnLock.Size := System.Drawing.Size.Create(64, 23);
  Self.btnUnLock.TabIndex := 4;
  Self.btnUnLock.Text := 'Un-Lock';
  Include(Self.btnUnLock.Click, Self.UnLock_Click);
  // 
  // lblLockContext
  // 
  Self.lblLockContext.Location := System.Drawing.Point.Create(16, 48);
  Self.lblLockContext.Name := 'lblLockContext';
  Self.lblLockContext.Size := System.Drawing.Size.Create(72, 16);
  Self.lblLockContext.TabIndex := 5;
  Self.lblLockContext.Text := 'Lock Context';
  // 
  // tbxLockKey
  // 
  Self.tbxLockKey.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
      or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.tbxLockKey.Location := System.Drawing.Point.Create(16, 107);
  Self.tbxLockKey.Name := 'tbxLockKey';
  Self.tbxLockKey.ReadOnly := True;
  Self.tbxLockKey.Size := System.Drawing.Size.Create(264, 20);
  Self.tbxLockKey.TabIndex := 6;
  Self.tbxLockKey.Text := '';
  // 
  // lblLockKey
  // 
  Self.lblLockKey.Location := System.Drawing.Point.Create(16, 91);
  Self.lblLockKey.Name := 'lblLockKey';
  Self.lblLockKey.Size := System.Drawing.Size.Create(56, 16);
  Self.lblLockKey.TabIndex := 7;
  Self.lblLockKey.Text := 'Lock Key';
  // 
  // lblResults
  // 
  Self.lblResults.Location := System.Drawing.Point.Create(16, 168);
  Self.lblResults.Name := 'lblResults';
  Self.lblResults.Size := System.Drawing.Size.Create(56, 16);
  Self.lblResults.TabIndex := 8;
  Self.lblResults.Text := 'Results';
  // 
  // tbxLockServer
  // 
  Self.tbxLockServer.Location := System.Drawing.Point.Create(16, 21);
  Self.tbxLockServer.Name := 'tbxLockServer';
  Self.tbxLockServer.Size := System.Drawing.Size.Create(200, 20);
  Self.tbxLockServer.TabIndex := 9;
  Self.tbxLockServer.Text := 'http://localhost';
  // 
  // lblLockServer
  // 
  Self.lblLockServer.Location := System.Drawing.Point.Create(16, 5);
  Self.lblLockServer.Name := 'lblLockServer';
  Self.lblLockServer.Size := System.Drawing.Size.Create(64, 16);
  Self.lblLockServer.TabIndex := 10;
  Self.lblLockServer.Text := 'Lock Server';
  // 
  // tbxPort
  // 
  Self.tbxPort.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
      or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.tbxPort.Location := System.Drawing.Point.Create(232, 21);
  Self.tbxPort.Name := 'tbxPort';
  Self.tbxPort.Size := System.Drawing.Size.Create(48, 20);
  Self.tbxPort.TabIndex := 11;
  Self.tbxPort.Text := '4242';
  // 
  // lblPort
  // 
  Self.lblPort.Location := System.Drawing.Point.Create(232, 5);
  Self.lblPort.Name := 'lblPort';
  Self.lblPort.Size := System.Drawing.Size.Create(40, 16);
  Self.lblPort.TabIndex := 12;
  Self.lblPort.Text := 'Port';
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(296, 245);
  Self.Controls.Add(Self.lblPort);
  Self.Controls.Add(Self.tbxPort);
  Self.Controls.Add(Self.lblLockServer);
  Self.Controls.Add(Self.tbxLockServer);
  Self.Controls.Add(Self.lblResults);
  Self.Controls.Add(Self.lblLockKey);
  Self.Controls.Add(Self.tbxLockKey);
  Self.Controls.Add(Self.lblLockContext);
  Self.Controls.Add(Self.btnUnLock);
  Self.Controls.Add(Self.btnIsLocked);
  Self.Controls.Add(Self.lbxResults);
  Self.Controls.Add(Self.tbxLockContext);
  Self.Controls.Add(Self.btnLockItem);
  Self.MinimumSize := System.Drawing.Size.Create(304, 272);
  Self.Name := 'TWinForm';
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'Lock service demo';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
var
  configFile: string;
begin
  inherited;
  configFile := Paramstr(0) + '.config';
  if System.IO.File.Exists(configFile) = false then
    begin
      MessageBox.Show('Error: unable to locate: '+configfile);
      halt;
    end
  else
    RemotingConfiguration.Configure(configFile);
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

function TWinForm.GetobjectRef: ILockserver;
var
  URL: string;
begin
  URL := trim(tbxLockServer.Text)+':'+trim(tbxPort.Text)+'/RNG.rem';
  Result := Activator.GetObject(typeof(ILockserver), URL) as ILockserver;
end;

procedure TWinForm.DisplayResults(const fMsg: string);
var
  i: integer;
begin
  lbxResults.Items.Add(fMsg);
  i := lbxResults.Height div lbxResults.ItemHeight;
  if (lbxResults.items.Count >= i) then
    lbxResults.TopIndex := lbxResults.items.Count - i + 1;
end;

procedure TWinForm.UnLock_Click(sender: System.Object; e: System.EventArgs);
begin
  try
    with GetobjectRef do
      DisplayResults(TF[UnLockitem(tbxLockKey.Text)]);
  except
    on e:exception do
      DisplayResults(e.Message);
  end;
end;

procedure TWinForm.IsLocked_Click(sender: System.Object; e: System.EventArgs);
begin
  try
    with GetobjectRef do
      DisplayResults(TF[IsItemLocked(tbxLockContext.Text)]);
  except
    on e:exception do
      DisplayResults(e.Message);
  end;
end;

procedure TWinForm.LockItem_Click(sender: System.Object; e: System.EventArgs);
var
  fKey: string;
begin
  try
    with GetobjectRef do
    begin
      DisplayResults(TF[Lockitem(tbxLockContext.Text, fKey)]);
      tbxLockKey.Text := fKey;
    end;
  except
    on e:exception do
      DisplayResults(e.Message);
  end;
end;

end.
